# Netlos Agency Management System (MVP)

CodeIgniter 4 + MySQL (InnoDB, utf8mb4) MVP.

## Requirements
- PHP 8.1+
- Composer
- MySQL 8+ / MariaDB 10.5+

## Install
1. `composer install`
2. Ensure `writable/` is writable
3. `php spark serve`
4. Open `http://localhost:8080/install`

## Installer
- `/install` is enabled until `writable/install/installed.lock` exists.
- Writes DB credentials to `writable/install/db_config.php`.
- Runs migrations and seeds default service types.
- Creates initial admin user.

## Roles
- `admin`: full access to all modules
- `staff`: only My Tasks, own task detail, own task status update

## Security
- CSRF on forms
- Server-side validation
- Session-based auth
- Password hashing via `password_hash()` / `password_verify()`
- Escaped outputs in views
