<?php

namespace App\Controllers\Admin;

use App\Controllers\BaseController;
use App\Models\CashTransactionModel;
use App\Models\CustomerModel;
use App\Models\ProjectModel;

class CashController extends BaseController
{
    public function index()
    {
        $model = new CashTransactionModel();

        $transactions = $model
            ->select('cash_transactions.*, customers.company_name, projects.name AS project_name')
            ->join('customers', 'customers.id = cash_transactions.customer_id', 'left')
            ->join('projects', 'projects.id = cash_transactions.project_id', 'left')
            ->orderBy('cash_transactions.date', 'desc')
            ->findAll();

        $income = (float) ($model->selectSum('amount')->where('type', 'income')->first()['amount'] ?? 0);
        $expense = (float) ($model->selectSum('amount')->where('type', 'expense')->first()['amount'] ?? 0);

        return $this->render('admin/cash/index', [
            'transactions' => $transactions,
            'income'       => $income,
            'expense'      => $expense,
            'balance'      => $income - $expense,
            'customers'    => (new CustomerModel())->findAll(),
            'projects'     => (new ProjectModel())->findAll(),
        ]);
    }

    public function create()
    {
        $rules = [
            'type'     => 'required|in_list[income,expense]',
            'date'     => 'required|valid_date',
            'amount'   => 'required|decimal',
            'category' => 'required|min_length[2]',
        ];

        if (! $this->validate($rules)) {
            return redirect()->back()->withInput()->with('error', 'Validation failed.');
        }

        (new CashTransactionModel())->insert([
            'type'        => $this->request->getPost('type'),
            'date'        => $this->request->getPost('date'),
            'amount'      => $this->request->getPost('amount'),
            'category'    => $this->request->getPost('category'),
            'customer_id' => $this->request->getPost('customer_id') ?: null,
            'project_id'  => $this->request->getPost('project_id') ?: null,
            'note'        => $this->request->getPost('note'),
            'created_by'  => session()->get('user_id'),
        ]);

        return redirect()->to('/admin/cash')->with('success', 'Transaction added.');
    }
}
