<?php

namespace App\Controllers\Admin;

use App\Controllers\BaseController;
use App\Models\CashTransactionModel;
use App\Models\CustomerInvoiceModel;
use App\Models\CustomerPaymentModel;
use App\Models\ProjectModel;
use App\Models\TaskModel;

class DashboardController extends BaseController
{
    public function index()
    {
        $projectModel = new ProjectModel();
        $taskModel = new TaskModel();
        $cashModel = new CashTransactionModel();
        $invoiceModel = new CustomerInvoiceModel();
        $paymentModel = new CustomerPaymentModel();

        $activeProjects = $projectModel->where('status', 'active')->countAllResults();
        $overdueTasks = $taskModel->where('status !=', 'done')->where('due_date <', date('Y-m-d'))->countAllResults();

        $income = (float) ($cashModel->selectSum('amount')->where('type', 'income')->first()['amount'] ?? 0);
        $expense = (float) ($cashModel->selectSum('amount')->where('type', 'expense')->first()['amount'] ?? 0);

        $invoiceTotal = (float) ($invoiceModel->selectSum('amount')->first()['amount'] ?? 0);
        $paymentTotal = (float) ($paymentModel->selectSum('amount')->first()['amount'] ?? 0);

        return $this->render('admin/dashboard/index', [
            'activeProjects'  => $activeProjects,
            'overdueTasks'    => $overdueTasks,
            'cashBalance'     => $income - $expense,
            'totalReceivable' => $invoiceTotal - $paymentTotal,
        ]);
    }
}
