<?php

namespace App\Database\Seeds;

use CodeIgniter\Database\Seeder;

class ServiceTypeSeeder extends Seeder
{
    public function run()
    {
        $default = ['Web', 'SEO', 'Google Ads', 'Meta Ads', 'Yazılım', 'Bakım', 'Tasarım'];

        foreach ($default as $name) {
            $exists = $this->db->table('service_types')->where('name', $name)->get()->getRowArray();
            if (! $exists) {
                $this->db->table('service_types')->insert([
                    'name'       => $name,
                    'is_active'  => 1,
                    'created_at' => date('Y-m-d H:i:s'),
                    'updated_at' => date('Y-m-d H:i:s'),
                ]);
            }
        }
    }
}
