<?= $this->extend('layouts/main') ?>
<?= $this->section('content') ?>
<div class="d-flex justify-content-between mb-3">
    <h3>Customers</h3>
    <a class="btn btn-primary" href="/admin/customers/create">New Customer</a>
</div>

<table class="table table-bordered">
    <thead><tr><th>ID</th><th>Company</th><th>Contact</th><th>Email</th><th>Active</th><th>Actions</th></tr></thead>
    <tbody>
    <?php foreach ($customers as $c): ?>
        <tr>
            <td><?= esc($c['id']) ?></td>
            <td><?= esc($c['company_name']) ?></td>
            <td><?= esc($c['contact_name']) ?></td>
            <td><?= esc($c['email']) ?></td>
            <td><?= (int) $c['is_active'] === 1 ? 'Yes' : 'No' ?></td>
            <td>
                <a class="btn btn-sm btn-info" href="/admin/customers/<?= esc($c['id']) ?>">Detail</a>
                <a class="btn btn-sm btn-warning" href="/admin/customers/<?= esc($c['id']) ?>/edit">Edit</a>
            </td>
        </tr>
    <?php endforeach; ?>
    </tbody>
</table>
<?= $this->endSection() ?>
