<?= $this->extend('layouts/main') ?>
<?= $this->section('content') ?>

<h3>Customer Detail: <?= esc($customer['company_name']) ?></h3>
<p><strong>Contact:</strong> <?= esc($customer['contact_name']) ?> | <strong>Phone:</strong> <?= esc($customer['phone']) ?></p>

<div class="row">
    <div class="col-md-4"><div class="card"><div class="card-body"><strong>Invoice Total</strong><div><?= number_format($invoiceTotal, 2) ?></div></div></div></div>
    <div class="col-md-4"><div class="card"><div class="card-body"><strong>Payment Total</strong><div><?= number_format($paymentTotal, 2) ?></div></div></div></div>
    <div class="col-md-4"><div class="card"><div class="card-body"><strong>Balance</strong><div><?= number_format($balance, 2) ?></div></div></div></div>
</div>

<h5 class="mt-4">Projects</h5>
<ul>
    <?php foreach ($projects as $p): ?>
        <li><?= esc($p['name']) ?> (<?= esc($p['status']) ?>)</li>
    <?php endforeach; ?>
</ul>

<div class="row mt-3">
    <div class="col-md-6">
        <h5>Add Invoice</h5>
        <form method="post" action="/admin/customers/<?= esc($customer['id']) ?>/invoices/create">
            <?= csrf_field() ?>
            <input class="form-control mb-2" type="date" name="date" required>
            <input class="form-control mb-2" type="text" name="title" placeholder="Title" required>
            <input class="form-control mb-2" type="number" step="0.01" name="amount" placeholder="Amount" required>
            <select class="form-select mb-2" name="project_id">
                <option value="">Project (optional)</option>
                <?php foreach ($projects as $p): ?><option value="<?= esc($p['id']) ?>"><?= esc($p['name']) ?></option><?php endforeach; ?>
            </select>
            <input class="form-control mb-2" type="number" step="0.01" name="vat_rate" placeholder="VAT Rate (optional)">
            <input class="form-control mb-2" type="number" step="0.01" name="vat_amount" placeholder="VAT Amount (optional)">
            <textarea class="form-control mb-2" name="note" placeholder="Note"></textarea>
            <button class="btn btn-success btn-sm">Add Invoice</button>
        </form>
    </div>

    <div class="col-md-6">
        <h5>Add Payment</h5>
        <form method="post" action="/admin/customers/<?= esc($customer['id']) ?>/payments/create">
            <?= csrf_field() ?>
            <input class="form-control mb-2" type="date" name="date" required>
            <input class="form-control mb-2" type="number" step="0.01" name="amount" placeholder="Amount" required>
            <select class="form-select mb-2" name="project_id">
                <option value="">Project (optional)</option>
                <?php foreach ($projects as $p): ?><option value="<?= esc($p['id']) ?>"><?= esc($p['name']) ?></option><?php endforeach; ?>
            </select>
            <select class="form-select mb-2" name="method">
                <option value="">Method (optional)</option>
                <option value="cash">cash</option>
                <option value="bank">bank</option>
                <option value="pos">pos</option>
                <option value="eft">eft</option>
                <option value="other">other</option>
            </select>
            <textarea class="form-control mb-2" name="note" placeholder="Note"></textarea>
            <button class="btn btn-primary btn-sm">Add Payment</button>
        </form>
    </div>
</div>

<h5 class="mt-4">Ledger Timeline</h5>
<table class="table table-bordered table-sm">
    <thead><tr><th>Date</th><th>Type</th><th>Title/Method</th><th>Amount</th></tr></thead>
    <tbody>
    <?php foreach ($timeline as $t): ?>
        <tr>
            <td><?= esc($t['date']) ?></td>
            <td><?= esc($t['type']) ?></td>
            <td><?= esc($t['title']) ?></td>
            <td><?= number_format((float) $t['amount'], 2) ?></td>
        </tr>
    <?php endforeach; ?>
    </tbody>
</table>
<?= $this->endSection() ?>
