<?= $this->extend('layouts/main') ?>
<?= $this->section('content') ?>
<h3><?= isset($serviceType) && $serviceType ? 'Edit Service Type' : 'Create Service Type' ?></h3>

<form method="post">
    <?= csrf_field() ?>
    <div class="mb-2">
        <label>Name</label>
        <input class="form-control" name="name" value="<?= esc(old('name', $serviceType['name'] ?? '')) ?>" required>
    </div>
    <div class="mb-2">
        <label>Active</label>
        <select class="form-select" name="is_active">
            <option value="1" <?= (int) old('is_active', $serviceType['is_active'] ?? 1) === 1 ? 'selected' : '' ?>>Yes</option>
            <option value="0" <?= (int) old('is_active', $serviceType['is_active'] ?? 1) === 0 ? 'selected' : '' ?>>No</option>
        </select>
    </div>
    <?php if (isset($validation)): ?><div class="text-danger small mb-2"><?= $validation->listErrors() ?></div><?php endif; ?>
    <button class="btn btn-success">Save</button>
    <a class="btn btn-secondary" href="/admin/service-types">Back</a>
</form>
<?= $this->endSection() ?>
