<?= $this->extend('layouts/main') ?>
<?= $this->section('content') ?>
<h3>Create User</h3>

<form method="post">
    <?= csrf_field() ?>
    <div class="mb-2"><label>Name</label><input class="form-control" name="name" value="<?= esc(old('name')) ?>" required></div>
    <div class="mb-2"><label>Email</label><input type="email" class="form-control" name="email" value="<?= esc(old('email')) ?>" required></div>
    <div class="mb-2"><label>Password</label><input type="password" class="form-control" name="password" required></div>
    <div class="mb-2">
        <label>Role</label>
        <select class="form-select" name="role">
            <option value="staff">staff</option>
            <option value="admin">admin</option>
        </select>
    </div>
    <?php if (isset($validation)): ?><div class="text-danger small mb-2"><?= $validation->listErrors() ?></div><?php endif; ?>
    <button class="btn btn-success">Save</button>
    <a class="btn btn-secondary" href="/admin/users">Back</a>
</form>
<?= $this->endSection() ?>
