<?= $this->extend('layouts/main') ?>
<?= $this->section('content') ?>
<div class="d-flex justify-content-between mb-3">
    <h3>Users</h3>
    <a class="btn btn-primary" href="/admin/users/create">New User</a>
</div>

<table class="table table-bordered">
    <thead><tr><th>ID</th><th>Name</th><th>Email</th><th>Role</th><th>Active</th><th>Action</th></tr></thead>
    <tbody>
    <?php foreach ($users as $u): ?>
        <tr>
            <td><?= esc($u['id']) ?></td>
            <td><?= esc($u['name']) ?></td>
            <td><?= esc($u['email']) ?></td>
            <td><?= esc($u['role']) ?></td>
            <td><?= (int) $u['is_active'] === 1 ? 'Yes' : 'No' ?></td>
            <td><a class="btn btn-sm btn-warning" href="/admin/users/<?= esc($u['id']) ?>/toggle">Toggle Active</a></td>
        </tr>
    <?php endforeach; ?>
    </tbody>
</table>
<?= $this->endSection() ?>
