<?= $this->extend('layouts/main') ?>
<?= $this->section('content') ?>
<div class="row justify-content-center">
    <div class="col-md-4">
        <h3>Login</h3>
        <form method="post" action="/login">
            <?= csrf_field() ?>
            <div class="mb-3">
                <label>Email</label>
                <input type="email" class="form-control" name="email" value="<?= esc(old('email')) ?>" required>
            </div>
            <div class="mb-3">
                <label>Password</label>
                <input type="password" class="form-control" name="password" required>
            </div>
            <?php if (isset($validation)): ?>
                <div class="text-danger small mb-2"><?= $validation->listErrors() ?></div>
            <?php endif; ?>
            <button class="btn btn-primary w-100">Login</button>
        </form>
        <a href="/install" class="small d-block mt-3">Run Installer</a>
    </div>
</div>
<?= $this->endSection() ?>
