<?= $this->extend('layouts/main') ?>
<?= $this->section('content') ?>
<div class="row justify-content-center">
    <div class="col-md-8">
        <h3>Quick Installer</h3>
        <form method="post" action="/install">
            <?= csrf_field() ?>
            <h5 class="mt-3">Database</h5>
            <div class="row">
                <div class="col-md-4 mb-2"><input name="db_host" class="form-control" placeholder="DB Host" value="<?= esc(old('db_host', 'localhost')) ?>" required></div>
                <div class="col-md-4 mb-2"><input name="db_name" class="form-control" placeholder="DB Name" value="<?= esc(old('db_name')) ?>" required></div>
                <div class="col-md-4 mb-2"><input name="db_user" class="form-control" placeholder="DB User" value="<?= esc(old('db_user')) ?>" required></div>
                <div class="col-md-4 mb-2"><input type="password" name="db_pass" class="form-control" placeholder="DB Password"></div>
                <div class="col-md-4 mb-2"><input name="db_port" class="form-control" placeholder="DB Port" value="<?= esc(old('db_port', '3306')) ?>" required></div>
                <div class="col-md-4 mb-2"><input name="base_url" class="form-control" placeholder="Base URL (optional)" value="<?= esc(old('base_url')) ?>"></div>
            </div>

            <h5 class="mt-3">Admin</h5>
            <div class="row">
                <div class="col-md-4 mb-2"><input name="admin_name" class="form-control" placeholder="Admin Name" value="<?= esc(old('admin_name')) ?>" required></div>
                <div class="col-md-4 mb-2"><input type="email" name="admin_email" class="form-control" placeholder="Admin Email" value="<?= esc(old('admin_email')) ?>" required></div>
                <div class="col-md-4 mb-2"><input type="password" name="admin_password" class="form-control" placeholder="Admin Password" required></div>
            </div>

            <?php if (isset($validation)): ?>
                <div class="text-danger small mb-2"><?= $validation->listErrors() ?></div>
            <?php endif; ?>

            <button class="btn btn-success">Install</button>
        </form>
    </div>
</div>
<?= $this->endSection() ?>
