<!doctype html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Netlos Agency Management</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
<nav class="navbar navbar-expand-lg navbar-dark bg-dark">
    <div class="container-fluid">
        <a class="navbar-brand" href="<?= esc(session()->get('role') === 'admin' ? '/admin/dashboard' : '/staff/my-tasks') ?>">Netlos</a>
        <?php if (session()->get('user_id')): ?>
            <div class="d-flex gap-2 align-items-center">
                <span class="text-white small"><?= esc(session()->get('name')) ?> (<?= esc(session()->get('role')) ?>)</span>
                <a href="/logout" class="btn btn-sm btn-outline-light">Logout</a>
            </div>
        <?php endif; ?>
    </div>
</nav>

<div class="container py-4">
    <?php if (session()->getFlashdata('success')): ?>
        <div class="alert alert-success"><?= esc(session()->getFlashdata('success')) ?></div>
    <?php endif; ?>

    <?php if (session()->getFlashdata('error')): ?>
        <div class="alert alert-danger"><?= esc(session()->getFlashdata('error')) ?></div>
    <?php endif; ?>

    <?= $this->renderSection('content') ?>
</div>
</body>
</html>
